/*----------------------------------------------------------------*
 *
 * File : jobs.h
 * Author : NTM
 * Created : 29/06/04
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _jobs_h_
#define _jobs_h_

/*!
  \file jobs.h
  \brief Definition of the JobIdent* datatypes to store all information
   relevant to one batch of simulations (ie, performed
   on a single node), or one real observed sig decoding.
*/

#define RANDGENLENGTH 256 /*!<length of randomGenMethod string in JobIdentSim datatype */

#define OUTFILELENGTH 1024 /*!<maximum length of output file name (including full path) */


/*!
  \brief Datatype to store all information relevant to one batch of simulations.
*/
typedef struct
{
  int n ; /*!< number of variables, */
  int nbPools ; /*!< number of pools */
  char *designFileName ; /*!< path/name of design file */
  int nbPosVars ; /*!< number of positive variables */
  int falsePos ; /*!< number of erroneous pos/weak observations per simm */
  int falseNeg ; /*!< idem false neg/faint */
  int nsim ; /*!< number of simms for this job */
  char *randomGenMethod ; /*!< string: identifier of the random generator method */
  unsigned int seed ; /*!< seed for the random generator */
  char *outFileName ; /*!< string containing path/name of output file that must be created */
} JobIdentSim ;

/*!
  \brief Datatype to store all information relevant to one real observed sig decoding.
*/
typedef struct
{
  int n ; /*!< number of variables */
  int nbPools ; /*!< number of pools */
  char *designFileName ; /*!< path/name of design file */
  char *inFileName ; /*!< path/name of input file containing the sig to decode */
  char *outFileName ; /*!< path/name of output file that must be created */
} JobIdentReal ;

#endif
