/*-----------------------------------------------------------*
 *
 * File : fonc.h
 * Author : NTM
 * Created : 30/09/03
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *------------------------------------------------------------*/

#ifndef _fonc_h_
#define _fonc_h_

/*!
  \file fonc.h
  \brief This file holds general math/numerical functions for InterPool.
*/


/*!
  \brief Return the smallest divisor of nn, or 0 if nn is prime.
*/
int firstDivisor(int nn);

/*!
  \brief Compare 2 ints (for qsort and bsearch).
*/
int compInts(const void* a, const void* b) ;

/*!
  \brief Calculate C(t,k) = k!/(t!*(k-t)!).
*/
unsigned long int choose(int t, int k) ;

#endif
