/*----------------------------------------------------------------*
 *
 * File : errorModel.h
 * Author : NTM
 * Created : 19/09/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _errorModel_h_
#define _errorModel_h_


/* \file errorModel.h
   \brief specify the error model to use when performing simulations and 
   validations, ie define the fractions of pos/weak among TPs and FPs, 
   etc... */

#define PP_FRAC 0.75 /* fraction of STRONG pools in the true positive pools */
#define NN_FRAC 0.90 /* fraction of NONE pools in the true negative pools */
#define PN_FRAC 0.10 /* fraction of STRONG pools in the false positive pools */
#define NP_FRAC 0.50 /* fraction of NONE pools in the false negative pools */


/* For example, the following values mean you use only STRONG and NONE,
   and not WEAK or FAINT. If you use the Hamming distance, you might 
   as well use these settings. */
//#define PP_FRAC 1 /* fraction of STRONG pools in the true positive pools */
//#define NN_FRAC 1 /* fraction of NONE pools in the true negative pools */
//#define PN_FRAC 1 /* fraction of STRONG pools in the false positive pools */
//#define NP_FRAC 1 /* fraction of NONE pools in the false negative pools */


#endif 
