/*----------------------------------------------------------------*
 *
 * File : doSTD.c
 * Author : NTM
 * Created : 17/07/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h> /* for mkdir */
#include <sys/types.h> /* also for mkdir */
#include <errno.h> /* for mkdir return status */

#include "STD.h" /* STD, DESIGN_DIR */


/*!
  \file doSTD.c
  \brief Main function for build STD design files.
*/



/*!
  \brief main function to build an STD design file.
*/
int main(int argc, char* argv[])
{
  if (argc != 4)
    {
      fprintf(stderr, "wrong number of args.\n") ;
      fprintf(stderr, "USAGE: ipoolSTD n q k\n") ;
      fprintf(stderr, "n, q, k: the STD parameters defining the pools used\n") ;
      exit(1) ;
    }

  int n = atoi(argv[1]) ;
  int q = atoi(argv[2]) ;
  int k = atoi(argv[3]) ;


  //--------------------------------------------------
  /* make DESIGN_DIR if it doesn't exist, but print a warning 
     to stderr in this case. In general, DESIGN_DIR should never
     get removed, therefore creating it should be exceptional...
     But for the parallel version this can be necessary, as we don't
     want to access each node's hardrive to mkdir by hand */
  //--------------------------------------------------
  {
    /* create DESIGN_DIR directory with perms 755 if it doesn't exist */
    extern int errno ;
    int status = mkdir(DESIGN_DIR, 511) ;
    if (status !=0)
      { /* if dir just already existed, continue; else die */
	if (errno != EEXIST)
	  {
	    fprintf(stderr, "Error creating directory DESIGN_DIR\n") ;
	    exit(1) ;
	  }
      }
    else
      /* directory did not exist: is this normal? */
      fprintf(stderr, "warning: created a new DESIGN_DIR. Check for multiple copies?\n") ;
  }


  STD(n, q, k) ;

  return(0) ;
}
