/*-----------------------------------------------------------*
 *
 * File : distance.h
 * Author : NB
 * Created : 13/02/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *------------------------------------------------------------*/

#ifndef _distance_h_
#define _distance_h_


/*!
  \file distance.h
  \brief This file defines the canonical interpretation of
  each acceptable discrete outcome (ie whether each
  observation value should be considered pos or neg);
  It also defines the distance between each discrete
  outcome and its non-canonical interpretation.
  The distances must be positive integers.
*/

/* Currently we allow 4 possible discrete pool outcomes:
   neg, faint, weak, and pos.
   neg and faint are canonically interpreted as negative;
   weak and pos are canonically interpreted as positive.
*/

/* 
   define distances:
   DIST_NEG == cost to interpret a 'neg' pool as positive;
   DIST_FAINT == cost to interpret a 'faint' pool as positive;
   DIST_WEAK == cost to interpret a 'weak' pool as negative;
   DIST_POS == cost to interpret a 'pos' pool as negative.
*/

/* one example, favoring sensitivity */
#define DIST_NEG 2
#define DIST_FAINT 1
#define DIST_WEAK 4
#define DIST_POS 6



/* example with the Hamming distance. In this case there is
   no difference between weak and pos, or between faint and neg;
   therefore when performing simulations/validations you might as 
   well modifiy XX_FRAC to just use pos and neg.
*/
/*
#define DIST_NEG 1
#define DIST_FAINT 1
#define DIST_WEAK 1
#define DIST_POS 1
*/



/*!
  \brief Return the max distance to change an outcome of neg canonical
  interpretation (ie change it to pos).
  This will typically be DIST_NEG.
*/
int maxDistNeg(void);

/*!
  \brief Return the min distance to change an outcome of neg canonical
  interpretation (ie change it to pos).
  This will typically be DIST_FAINT.
*/
int minDistNeg(void);

#endif
