/*-----------------------------------------------------------*
 *
 * File : distance.c
 * Author :  NB
 * Created : 13/02/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *------------------------------------------------------------*/

#include <stdio.h> // for printing
#include <stdlib.h> // for exit
#include "signa.h" // SIG_***

#include "distance.h"


/************************************************************************
 ******************* EXPORTED FUNCTIONS *********************************
 ************************************************************************/

/*!
  \brief Return the max distance to change an outcome of neg canonical
  interpretation (ie change it to pos).
  This will typically be DIST_NEG.
*/
int maxDistNeg(void)
{
  if (DIST_NEG >= DIST_FAINT)
    return DIST_NEG;
  else 
    return DIST_FAINT;
}


/*!
  \brief Return the min distance to change an outcome of neg canonical
  interpretation (ie change it to pos).
  This will typically be DIST_FAINT.
*/
int minDistNeg(void)
{
  if (DIST_NEG >= DIST_FAINT)
    return DIST_FAINT ;
  else 
    return DIST_NEG ;
}
