/*----------------------------------------------------------------*
 *
 * File : design.h
 * Author : NTM
 * Created : 06/07/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _design_h_
#define _design_h_

#include "types.h" /* MOT */

/*!
  \file design.h
  \brief Everything specific to the pooling design should go here.
*/


/*!
  \brief return the max number of pools that can contain 
  any 2 variables. 
*/
int maxInterBetweenVars(MOT* tabpool, int n, int nbPools) ;


/*!
  \brief return the max number of pools that can contain
  any single variable.
*/
int maxPoolsPerVar(MOT* tabpool, int n, int nbPools) ;

/*!
  Return the expected number of negative pools.
  This can be a rough estimate.
*/
int expectedNegPools(int n, int nbPools, int nbPosVars) ;


#endif
