/*----------------------------------------------------------------*
 *
 * File : decodeObservedSig.h
 * Author : NTM
 * Created : 01/04/05
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _decodeObservedSig_h_
#define _decodeObservedSig_h_

#include "jobs.h" /* JobIdentReal */


/*!
  \file decodeObservedSig.h
  \brief Entry point for decoding a real, observed signature.
*/


/*!
  \brief  Decode one real observed signature, and output results: <br>
  merged deduced positive and ambiguous variables (merged from each 
  nearest coherent sig); followed by the lists  of positives and ambis, 
  along with the absolute pool numbers of erroneous pools, for
  each nearest coherent sig. mode chooses the solvexp method. <br>
  Current modes are:
         - 1: use solvexpNaive
	 - 4: use solvexpClosure (findBestClosuresReal with Rec)
	 - 5: use solvexpClosure (findBestClosuresReal with RecSubstracted)
	 If unsure, use mode 5.
*/
void decodeObservedSig(JobIdentReal *thisJob, int mode) ;

#endif /* ifndef */

