/*----------------------------------------------------------------*
 *
 * File : conflicts.h
 * Author : NTM
 * Created : 24/11/04
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------*/

#ifndef _conflicts_h_
#define _conflicts_h_

#include "types.h" /* MOT, bool */
#include "signa.h" /* signature */


/*!
  \file conflicts.h
  \brief This is part of my reimplementation of the solvexpClosure 
  method. This file holds methods for identifying conflicting
  pools and variables, enriching signatures by marking the
  conflicts, etc...
*/


/*!
  \brief sig0 is an observation: it can hold only SIG_NEG, SIG_FAINT, 
  SIG_WEAK or SIG_POS;<br>
  this function builds and returns a signature where conflicts are
  tagged: all conflicting pools get their sig values changed from
  SIG_XXX to SIG_XXXCONF.
*/
signature* enrichSig(MOT* tabpool, signature* sig0, int n) ;


/*!
  \brief Given an enriched observation, return the distance to the 
  coherent interpretation where all conflicting pos and weak pools
  are changed to neg. This can be seen as the "cost" of Pc+Wc.
*/
int costOfConflictingPosWeak(signature* sig) ;

/*!
  \brief Given an enriched signature, build and return a vector
  of n bools: value [i] is true if variable i is a conflicting 
  var (ie, appears in a conflicting pos or weak pool).
*/
bool* buildConflictingVars(MOT* tabpool, signature* sig, int n);


#endif
