/*-------------------------------------------------------------*
 *
 *File : config.h
 *Author : NTM
 *Created : 30/09/03
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *--------------------------------------------------------------*/

#ifndef _config_h_
#define _config_h_


/*! 
  \file config.h
  \brief Global configuration macros for InterPool
*/

/*! OUTDIR: directory where result files should go */
#define OUTDIR "InterPool.Results/"

/*! define for special optimizations when using STD pools, 
  comment out otherwise */
#define USING_STD


/* The Worm AD Smart-Pools (WASP) are based on STD,
   but some WASP2 batches use designs that are intermediate
   between 2 STD designs. Define the following (and undef
   USING_STD) to deal efficiently with the WASP pools.
   comment otherwise. */
//#define USING_WASP


/*! CONST_SEED: define to use a constant seed in myrand.c 
  (for profiling or testing) */
//#define CONST_SEED
#undef CONST_SEED

#endif /* ifndef _config_h_ */

