/*-----------------------------------------------------------*
 *
 * File : STD.h
 * Author : NTM
 * Created : 16/07/06
 *
 *
 * Copyright (C) Nicolas Thierry-Mieg, 2006.
 *
 *
 * This file is part of InterPool, written by 
 * Nicolas Thierry-Mieg (CNRS, France) Nicolas.Thierry-Mieg@imag.fr
 *
 * InterPool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InterPool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InterPool; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *------------------------------------------------------------*/

#ifndef _STD_h_
#define _STD_h_

/*!
  \file STD.h
  \brief This file holds the stuff specific to STD.
*/

 /*! path to the subdir where codefiles are saved (relative 
   to the dir where the binary is called) */
#define DESIGN_DIR "designFiles/"


 /*! max length (ie number of characters) of designFile name 
   (including path). */
#define DESIGNFILELENGTH 1024


/*!
  \brief Calculate the compression value of q relative to n, ie
  the smallest c such that q^(c+1) >= n.
 */
int compression(int q, int n);

/*!
  \brief Return the "optimal" q value (ie, such that 50% pools are positive) 
  to use for STD.
*/
int optimalq(int n, int nbPosVars) ;

/*!
  \brief return the average pool size when using STD.
*/
int poolSizeSTD(int n, int nbPools) ;

/*!
  \brief calculate q (STD parameter): it is the largest prime
  factor of nbPools.
*/
int calculateQ(int nbPools) ;

/*!
  \brief calculate k (STD parameter).
*/
int calculateK(int nbPools) ;


/*!
  \brief Build the pools STD(n;q;k) and save them to a
  file in the interPool design format.
  File will be named STD.n<n>.q<q>.k<k> and placed in DESIGN_DIR, which
  must exist.
  See BMC Bioinformatics 2006 paper by Thierry-Mieg for definition of STD.
  n=number of variables, q=number of pools per layer, k=number of layers.
*/
void STD(int n,int q,int k) ;


/*!
  buildqs: returns an array (allocated here) of at most nbofqs values 
  for q. 
  Not used anymore, but could be used as follows:
  int qopt = optimalq(n, nbPosVars) ;
  int* allqs = buildqs(qopt, nbofqs, qmin, qmax) ;
  We then have a nice list of q values, useful when performing a 
  first shallow set of simulations with STD.
  This was used in doSimulations.c up to ntm.060707.
*/
int* buildqs(int qopt, int nbofqs, int qmin, int qmax) ;


#endif
