#!/usr/bin/env perl

# Author: NTM

#
# Copyright (C) Nicolas Thierry-Mieg, 2009.
#
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This script is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this script; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


# decode a lot of WASP sigfiles

use strict ;
use warnings ;


# for GR package: block copied from decodeWASP.pl, to print
# a single clear error message if user hasn't compiled interpool
my $ipoolDecoding = "../interpool-090303_GR/src/ipoolDecoding" ;
if (! -f $ipoolDecoding)
{
    # for cygwin, binaries end in .exe, try it
    (-f $ipoolDecoding.".exe") ||
	die "ipoolDecoding binary to use ($ipoolDecoding) doesn't exist, maybe you didn't compile interpool? look in ../interpool-090303_GR/\n" ;
}



# WASP type: WASP2 or WASP6 or WASP2_384
my @types = ("WASP6", "WASP2", "WASP2_384") ;

foreach my $type (@types)
{
    # ipdist to use
    my $ipdist = "6412" ;

    (-e "Decodings.$type") && die "Decodings.$type/ exists, remove or rename\n" ;
    mkdir("Decodings.$type") || die "no mkdir" ;

    opendir(DIR, "Sigs.$type/") || die "no opendir" ;

    while(my $bait = readdir(DIR))
    {
	($bait =~ /^(T\d\d\d)/) ||
	    ((warn "$bait not bait dir\n") && next) ;

	
	system("decodeWASP.pl Sigs.$type/$bait $ipdist\n") ;
	warn"\nOK, moving Decodings/ to Decodings.$type/$bait\n\n" ;
	system("mv Decodings/ Decodings.$type/$bait/\n") ;
    }
}
