#!/usr/bin/env perl

# Author: NTM

#
# Copyright (C) Nicolas Thierry-Mieg, 2009.
#
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This script is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this script; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


# just calls colonyToSig.pl on all colony3 files in $xfdir,
# and organizes the produced sig files.

use strict ;
use warnings ;


my @types = ("WASP6", "WASP2", "WASP2_384") ;


# make sure dirs don't already exist
foreach my $type (@types)
{
    (-d "Sigs.$type") && die "Sigs.$type subdir exists, remove or rename it. " ;
}

# generate all sigs files
foreach my $type (@types)
{
    my $xfdir = "../Results.Colony3/$type/" ;

    opendir(DIR, "$xfdir") || die "no opendir\n" ;

    while (my $subdir = readdir(DIR))
    {
	($subdir =~ /^(T\d\d\d)/) || 
	    ($subdir =~ /(T\d\d\d)/) || 
	    ((warn "skipping $subdir\n") && next) ;

	my $bait = $1 ;

	opendir(SUBD, "$xfdir/$subdir/") || die "cannot opendir subdir $subdir\n" ;

	while (my $waspdir = readdir(SUBD))
	{
	    ($waspdir =~ /^\./) && next ;
	    ($waspdir =~ /^s\d+-d\d+-\d+m$/) || 
		($waspdir =~ /^T\d\d\d-s\d+$/) ||
		($waspdir =~ /^T\d\d\d-s\d+-d\d+$/) ||
		($waspdir =~ /^WASP/) ||
		((warn "not waspdir, skipping $waspdir\n") && next) ;
	    
	    warn "colonyToSig.pl $xfdir/$subdir/$waspdir/\n" ;
	    system("colonyToSig.pl $xfdir/$subdir/$waspdir/\n") ;

	    (-d "Sigs/$bait/") || (mkdir "Sigs/$bait/") ;
	    
	    system("mv -i Sigs/$bait\[-_\]* Sigs/$bait/\n") ;
	    
	}
    }

    closedir(DIR) || die "cannot closedir $xfdir???" ;

    # all sigs for $type are in Sigs/, move to Sigs.$type
    system("mv Sigs Sigs.$type") ;
}

