#!/usr/bin/env perl

#
# Copyright (C) Nicolas Thierry-Mieg, 2009.
#
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This script is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this script; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


# script to generate the batch2design.WASP<2|6> files.
# These say which design file should be used with each
# WASP2 and WASP6 batch.

use strict ;
use warnings ;


# for WASP6:  
# - batches 1,3,5,7,9,11 -> STD.n2028.q13.k13.BPP6.part1,
# - batches 2,4,6,8,10,12 -> STD.n2028.q13.k13.BPP6.part2,
# - batch 13 -> STD.n2028.q13.k13.BPP3.part1.
my $B2D = "batch2design.WASP6" ;
(-e "$B2D") && die "$B2D already exists, dying\n" ;
open(B2D,">$B2D") ||
    die "cannot open $B2D for writing\n" ;

print B2D "# Design files to use for each WASP6 batch\n" ;
print B2D "Batch,DesignFile\n" ;
foreach my $i (1..12)
{
    print B2D "$i,STD.n2028.q13.k13.BPP6.part", 2 - ($i % 2), "\n" ;
}
print B2D "13,STD.n2028.q13.k13.BPP3.part1\n" ;
close (B2D) ;



# for WASP2:
$B2D = "batch2design.WASP2" ;
(-e "$B2D") && die "$B2D already exists, dying\n" ;
open(B2D,">$B2D") ||
    die "cannot open $B2D for writing\n" ;

print B2D "# Design files to use for each WASP2 batch\n" ;
print B2D "Batch,DesignFile\n" ;

# batches 1-4,40 -> STD.n2028.q13.k13.BPP1.partX with X==1,2,3,4,3
foreach my $i (1..4)
{
    print B2D "$i,STD.n2028.q13.k13.BPP1.part$i\n" ;
}

# batches 5-8 -> ...BPP2.partX.SplitFirst94 (X==3-6 resp)
foreach my $i (5..8)
{
    print B2D 
	"$i,STD.n2028.q13.k13.BPP2.part",
	($i - 2), ".SplitFirst94\n" ;
}

# batches 9,10 -> ...BPP2.partX.SplitFirst19 (X==1,2 resp)
print B2D "9,STD.n2028.q13.k13.BPP2.part1.SplitFirst19\n" ;
print B2D "10,STD.n2028.q13.k13.BPP2.part2.SplitFirst19\n" ;

# batches 11-36 -> STD.n2028.q13.k13.BPP2.partX with
# X==3-6,(1-6)x3,1-4
foreach my $i (11..36)
{
    print B2D 
	"$i,STD.n2028.q13.k13.BPP2.part",
	(($i - 9) % 6) + 1, "\n" ;
}

# batches 37,38 -> ...BPP2.partX.SplitLast75 (X==5,6 resp)
print B2D "37,STD.n2028.q13.k13.BPP2.part5.SplitLast75\n" ;
print B2D "38,STD.n2028.q13.k13.BPP2.part6.SplitLast75\n" ;

# batch 39 -> STD.n2028.q13.k13.BPP2.part1
print B2D "39,STD.n2028.q13.k13.BPP2.part1\n" ;

# batch 40 -> STD.n2028.q13.k13.BPP1.part3
print B2D "40,STD.n2028.q13.k13.BPP1.part3\n" ;

close (B2D) ;


