#!/usr/bin/env perl

#
# Copyright (C) Nicolas Thierry-Mieg, 2009.
#
#
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This script is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this script; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


# For generating the "special" split designs of WASP2.
# Read some STD partial design files, and generate
# similar designs but where some of the pools have
# been split into pairs (one with small var numbers
# and the other with big vars).
# The second pool of a split pair is placed at the end
# of the design file.
#
# USAGE: current dir must contain a symlink to 
# STD.n2028.q13.k13.blocsPerPart2/ which holds the initial
# partial design files.
# This script will produce in the current dir all special 
# split design files required for WASP2.


use strict ;
use warnings ;

# original parts files are $desRoot."1" through "6"
my $desRoot = "STD.n2028.q13.k13.blocsPerPart2/STD.n2028.q13.k13.part" ;


# generate split.first94 and split.first19
# we need parts 3-6 of first94, respectively for WASP2 batches 5-8 ;
# and parts 1-2 of first19, for WASP2 batches 9 and 10 resp.
foreach my $part (1..6)
{
    my $numToSplit = 94 ;
    ($part <= 2) && ($numToSplit = 19) ;
    open(DES, "$desRoot$part") ||
	die "cannot open $desRoot$part\n" ;
    my $outfile = "STD.n2028.q13.k13.BPP2.part$part.SplitFirst$numToSplit" ;
    (-e $outfile) && (warn "$outfile exists, skipping\n") && next ;
    open (OUT, ">$outfile") ||
	die "cannot open $outfile for writing\n" ;
    
    my $poolsDone = 0 ;
    my $toPrint = "" ;
    while(my $line = <DES>)
    {
	($poolsDone == $numToSplit) && (print OUT $line) && next ;

	chomp $line ;
	my @vars = split(/:/, $line) ;
	while ($vars[0] < 169)
	{
	    my $var = shift(@vars) ;
	    print OUT "$var:" ;
	}
	print OUT "\n" ;
	# remaining vars in @vars are >= 169, they go in $toPrint
	$toPrint .= join(':',@vars) ;
	$toPrint .= ":\n" ;

	$poolsDone++ ;
    }
    print OUT $toPrint ;

    close(OUT) ;
    close(DES) ;
}


# now generate split.last75, code almost identical
foreach my $part (5,6)
{
    my $numToSplit = 75 ;
    open(DES, "$desRoot$part") ||
	die "cannot open $desRoot$part\n" ;
    my $outfile = "STD.n2028.q13.k13.BPP2.part$part.SplitLast$numToSplit" ;
    (-e $outfile) && (warn "$outfile exists, skipping\n") && next ;
    open (OUT, ">$outfile") ||
	die "cannot open $outfile for writing\n" ;
    
    # number of initial pools to leave as is (since we split the lastX)
    my $poolsToSkip = 169 - $numToSplit ;
    foreach my $i (1..$poolsToSkip)
    {
	my $line = <DES> ;
	print OUT $line ;
    }
    my $toPrint = "" ;
    while(my $line = <DES>)
    {
	chomp $line ;
	my @vars = split(/:/, $line) ;
	while ($vars[0] < 169)
	{
	    my $var = shift(@vars) ;
	    print OUT "$var:" ;
	}
	print OUT "\n" ;
	# remaining vars in @vars are >= 169, they go in $toPrint
	$toPrint .= join(':',@vars) ;
	$toPrint .= ":\n" ;
    }
    print OUT $toPrint ;

    close(OUT) ;
    close(DES) ;
}
