#include "Timer.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void start_timer(Timer* t) {
  t->start = t->last_info = time(NULL);
  t->info_wait = 2;
}

void showsec(FILE *fp, int sec) {
  int min = sec / 60;
  sec -= min * 60;
  int hour = min / 60;
  min -= hour * 60;
  int day = hour / 24;
  hour -= day * 24;
  int show = 0;
  if(day > 0) show = 1;
  if(show) fprintf(fp, "%d days ", day);
  if(hour > 0) show |= 1;
  if(show) fprintf(fp, "%d:", hour);
  if(min > 0) show |= 1;
  if(show) fprintf(fp, "%.2d'", min);
  fprintf(fp, "%.2d\"", sec);
}

void timer_info(FILE *fp, Timer *t, int i, int n) {
  time_t cur = time(NULL);
  if (cur - t->last_info < t->info_wait)  return;
  t->last_info = cur;
  int dtime = cur - t->start;
  double total_est = dtime * (double)(n) / i;
  int rsec = total_est - dtime;

  fprintf(fp, "%d / %d: ", i, n);

  showsec(fp, dtime);
  fprintf(fp, " elapsed, ");
  showsec(fp, rsec);
  fprintf(fp, " remaining\n");
  fflush(fp);
}

char *current_date() {
  char fn[] = "date.XXXXXX";
  mkstemp(fn);
  static char buffer[1000];
  strcpy(buffer, "date > ");
  strcat(buffer, fn);
  strcat(buffer, "; hostname >> ");
  strcat(buffer, fn);
  system(buffer);

  FILE * fp = fopen(fn, "r");
  fgets(buffer, 1000, fp);
  if(buffer[strlen(buffer)-1] == '\n')  
    buffer[strlen(buffer)-1] = '\0';
  fclose(fp);
  remove(fn);
  return buffer;
}
