#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "LSM.h"
#include "SeqIO.h"

int set_gc(Seq *s) {
  char *p;
  s->gc = 0;
  for(p=s->seq; *p; p++)
    if((*p == 'G') || (*p == 'C')) s->gc++;
  return s->gc;
}


Seq *new_Seq(char *id, char *seq) {
  Seq *s = (Seq*)malloc(sizeof(Seq));

  s->id = strdup(id);
  s->seq = strdup(seq);
  // convert to upper case
  char *p;
  for(p = s->seq; *p; p++) *p = toupper(*p);
  s->len = strlen(s->seq);
  set_gc(s);

  return s;
}



Seq *next_Seq(FILE *fp) {
  char id[MAX_LINE_LEN+1];
  char line[MAX_LINE_LEN+1];


  if (!next_line(fp, line))  return NULL;

  if(strncmp(line,">",1)) {
    printf("Error: expecting ID line, got\n%s", line);
    exit(1);
  }
  
  // cut off newline, if it exists
  if(!strcmp(line + strlen(line) - 1, "\n"))
    line[strlen(line)-1] = '\0';

  // cut out leading '>'
  strcpy(id, line+1);

  long buf_size = MAX_LINE_LEN;

  char *seq = (char*)malloc((buf_size+1) * sizeof(char));
  seq[0] = '\0';

  long pos = ftell(fp);
  while(next_line(fp,line) && strncmp(line, ">", 1)) {
    // cut off newline if it is there
    if(!strcmp(line + strlen(line) - 1, "\n"))
      line[strlen(line)-1] = '\0';

    // make sure there is space in the buffer
    if (strlen(line) + strlen(seq) > buf_size) {
      buf_size = 2*(strlen(line) + strlen(seq)) + 1;
      seq = (char*)realloc(seq, (buf_size+1)*sizeof(char));
    }

    strcat(seq, line);

    pos = ftell(fp);
  }
  
  // stopped because of another ID line
  //  printf("last line read: [%s]\n", line);
  if(!strncmp(line, ">", 1)) fseek(fp, pos, SEEK_SET);

  Seq *s = new_Seq(id, seq);
  free(seq);
  return s;
}


void save_Seq(Seq* s, FILE* fp) {
  fprintf(fp,">%s\n", s->id);

  // should be LINE_LENGTH+1
  char line[61];
  line[60] = '\0';

  int p;
  for(p = 0; p < strlen(s->seq); p += LINE_LENGTH) {
    strncpy(line, s->seq + p, 60);
    fprintf(fp, "%s\n", line);
  }
}


char *subseq(Seq* s, int start, int end) {
  if (start <= end) {
    char *ss = (char*) malloc((end-start + 2) * sizeof(char));

    if (start < 0) {
      start = s->len + start;
    }  else if (start > 0) {
      start--;
    }  else {
      printf("Error: I can't take subsequences starting at 0\n");
      exit(2);
    }

    if (end < 0) {
      end = s->len + end;
    }  else if (end > 0) {
      end--;
    }  else {
      printf("Error: I can't take subsequences ending at 0\n");
      exit(2);
    }

    strncpy(ss, s->seq + start, end - start + 1);
    ss[end-start+1] = '\0';
    
    return ss;
  }  else {
    char *ss = (char*) malloc(sizeof(char));
    *ss = '\0';
    return ss;
  }
}

void destroy_Seq(Seq *s) {
  free(s->id);
  free(s->seq);
  free(s);
}
