#ifndef __MARKOV_H
#define __MARKOV_H
#include <stdio.h>
void init_kmers();
char ***make_all_kmers(int);

int pow4_fcn(int);

char *IA_to_str(int*, int*);

// Alphabet is assumed to be ACGT


// supply (code or kmer) and k
char* code_to_kmer(int, int);
int kmer_to_code(char*, int);
int alpha_to_code(char);
void free_all_kmers();

typedef struct {
  double p[5];
  int logp[5];
} Pos;

Pos* new_Pos(double, double, double, double);
Pos* copy_Pos(Pos*);
Pos* next_Pos(FILE *);
void save_Pos(Pos *, FILE*, int);  // int is either PROBS or LOGP (what to "save")
int Pos_OK(Pos *);  // check that probs add to 1
char Pos_generate(Pos *);


// This structure has functions that will scan sequences
// and keep a running count of all kmers seen. Then it
// can be converted at some point into a Markov
//
// counts are kept as double because we will need fractional
// counts for the EM algorithm
typedef struct {
  int k;
  // count[kmer_code] counts kmers
  double *count;
} KmerCounter;
// supply k only, it will initialize
KmerCounter *new_KmerCounter(int);
// return value is same as (first) argument (RVSFA)
KmerCounter *reset_KmerCounter(KmerCounter *);

// counts all the kmers in the string (RVSFA)
// double is a weight (typically 1.0)
KmerCounter *add_kmers(KmerCounter *, char*, double);  

void dump_KmerCounter(KmerCounter*);
void destroy_KmerCounter(KmerCounter*);


typedef struct {
  int k;       // order of the model

  // transition probabilities
  // p[kmer_code] is a Pos*
  Pos **p;
} Markov;

Markov *new_Markov(int);
Markov *copy_Markov(Markov*);
void destroy_Markov(Markov*);
Markov *load_Markov(FILE*);
// what is either PROBS or LOGP
// LOGP is only for display, not for re-loading
void save_Markov(Markov*, FILE*, int);

void Markov_to_R(Markov*, FILE*);

// Note: if counter is for k-mers then order of markov has to
// be k-1, since transition is one nucleotide
Markov* new_Markov_from_KmerCounter(KmerCounter *);

Markov* new_Markov_from_FA(FILE *, int);

Markov* new_Markov_increase_order(Markov*, int);
Markov* new_Markov_decrease_order(Markov*, int);  // just take average

// how much info in first rel. to second
double Markov_rel_ent(Markov*, Markov*);

// score a whole sequence or integer array (start and end ptrs)
int Markov_score(Markov*, char *);
double Markov_prob(Markov*, char *);

// return an array of scores of intial (or terminal) segments
// what = PROBS or LOGP
void* Markov_vec(Markov*, char *, int terminal, int cumulative, int what);

char Markov_generate_char(Markov*, char*);
char* Markov_generate(Markov*, char*, int);


  

#endif
