#ifndef __LSM_H
#define __LSM_H
#include <math.h>
#include <stdio.h>

#ifdef LSM
const int MAX_LINE_LEN = 10000;
#else
extern int MAX_LINE_LEN;
#endif

// log and exp base 2
double log2(double);
double exp2(double);

// nearest integer to ROUNDING_FACTOR times log base 2
int log2_rounded(double);
double exp2_rounded(int);  // arg is from log2_rounded

// length of a -1 -terminated array
int len_double(double*);
int len_int(int*);

// dump -1 -iterminated arrays
void dump_double(double*);
void dump_int(int*);

// floating point equal (see thresh in LSM.c)
int fpe(double, double);

//
char* next_line(FILE *, char *);


// The copy_* functions malloc space and
// copy -1 -terminated arrays
double *copy_double(double *);
int *copy_int(int *);
int *copy_n_int(int*, int);


int rand_from_p(double *);

// special arguments for certain I/O functions (usually called "what",
// as in "what to output")
#define COUNTS 0
#define PROBS 1
#define LOGP 2

#endif
