#include <math.h>
#include <stdlib.h>
#include <string.h>
// This #define lets LSM.h know to define MAX_LINE_LEN
// rather than assume it is in another module
#define LSM
#include "LSM.h"
double log2_value = 0.69314718055994530942;
double thresh = 1e-04;  // threshhold for floating point equal
const double ROUNDING_FACTOR = 100.0;

inline double log2(double x) {
  return log(x) / log2_value;
}

inline double exp2(double x) {
  return exp(x*log2_value);
}

inline double exp2_rounded(int x) {
  return exp2(x / ROUNDING_FACTOR);
}

inline int log2_rounded(double x) {
  long l = (long)roundl(ROUNDING_FACTOR*log2(x));
  return l;
}

int len_double(double *d) {
  int n = 0;
  double *p;
  for(p= d; *p > -0.5; p++) n++;
  return n;
}

void dump_double(double *d) {
  int i;
  for(i=0; d[i] > -0.5; i++)
    printf("double[%d] = %g\n", i, d[i]);
}

int len_int(int *i) {
  int n = 0;
  int *p;
  for(p= i; *p > -1; p++) n++;
  return n;
}

void dump_int(int *i) {
  int n;
  for(n=0; i[n] > -1; n++)
    printf("int[%d] = %d\n", n, i[n]);
}

// floating point equal
int fpe(double a, double b) {
  double d = a - b;
  return (d < thresh) && (d > -thresh);
}


char *next_line(FILE *fp, char *s) {
  //  puts("next_line");
  while(!feof(fp)) {
    // should be fgets(s,MAX_LINE_LEN,fp) but it won't compile
    if (!fgets(s, MAX_LINE_LEN, fp)) return NULL;
    //    printf("got %s\n",s);
    if(!strcmp(s,"__CUT__\n")) return NULL;
    
    if(strncmp(s,"#",1) &&
       (strspn(s, " \t\n") < strlen(s))  // not entirely whitespace
       ) return s;
  }

  return NULL;  // end of file
}
  

double *copy_double(double *old) {
  int i;
  double *new = (double*)malloc((1+len_double(old)) * sizeof(double));
  for(i = 0; old[i] > -0.5; i++)  new[i] = old[i];
  new[i] = -1;
  return new;
}

int *copy_int(int *old) {
  int i;
  int *new = (int*)malloc((1+len_int(old)) * sizeof(int));
  for(i = 0; old[i] > -1; i++)  new[i] = old[i];
  new[i] = -1;
  return new;
}

int *copy_n_int(int *old, int n) {
  int i;
  int *new = (int*)malloc(n * sizeof(int));
  for(i = 0; i < n; i++)  new[i] = old[i];
  return new;
}


int rand_from_p(double *p) {
  double cp = 0;
  double rp = (double)(rand()) / RAND_MAX;
  
  int i;
  for(i = 0; p[i] > -0.5; i++)  {
    cp += p[i];
    if (cp > rp)  return i;
  }  

  if (fpe(cp, 1)) return i-1;

  printf("Error: Couldn't generate rand_from_p:\n");
  for(i = 0; p[i] > -0.5; i++)  printf(" %g", p[i]);
  printf("\nrp = %g\tcp=%g\n", rp, cp);
  exit(3);
}
  


