#include <stdio.h>
#include <stdlib.h>
#include "Markov.h"
#include "CollStats.h"


/* quicksort() and partition() from http://en.wikipedia.org/wiki/Quicksort#C
   modified for CollStats */
int partitionCS(CollStats *y[], int f, int l) {
  //  printf("partition(%d,%d)\n", f, l); 
  int up,down;
  CollStats *temp;
  register double piv = y[f]->P;
  up = f;
  down = l;
  do { 
    while (y[up]->P <= piv && up < l) {
      up++;
    }
    while (y[down]->P > piv && down > f ) {
      down--;
    }
    //printf("  (%d,%d)\n", up, down);
    if (up < down ) {
      temp = y[up];
      y[up] = y[down];
      y[down] = temp;
    }
  } while (down > up);
  temp = y[f];
  y[f] = y[down];
  y[down] = temp;
  return down;
}
void quicksortCS(CollStats *x[], int first, int last) {
  //fprintf(stderr,"quicksort(%d,%d)\n", first, last);
  //static int pivots = 0;
  int pivIndex = 0;
  if(first < last) {
    pivIndex = partitionCS(x,first, last);
    quicksortCS(x,first,(pivIndex-1));
    quicksortCS(x,(pivIndex+1),last);
  }
  //fprintf(stderr,"quicksort(%d,%d): #pivots = %d\t pivot=%d\n",
  //first, last, pivots++, pivIndex);

}


CollStats *new_CollStats(int kc1, int kc2, int n, double muNonSt,
			 double mu, double P) {
  CollStats *new=(CollStats*)malloc(sizeof(CollStats));
  new->kc1 = kc1;
  new->kc2 = kc2;
  new->n = n;
  new->muNonSt = muNonSt;
  new->mu = mu;
  new->P = P;
  return new;
}

void write_CollStats(CollStats *cs, FILE *fp, int k, int write_P) {
  make_all_kmers(k);
  fprintf(fp, "%s\t%s\t%d\t%g\t%g",
	  code_to_kmer(cs->kc1, k),
	  code_to_kmer(cs->kc2, k),
	  cs->n, cs->muNonSt, cs->mu);
  if(write_P) fprintf(fp,"\t%g", cs->P);
  fprintf(fp, "\n");
}
