/*
Copyright 2007 Daniel Zerbino (zerbino@ebi.ac.uk)

    This file is part of Velvet.

    Velvet is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Velvet is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Velvet; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include "run.h"

int main(int argc, char **argv)
{
	ReadSet *allSequences;
	SplayTable *splayTable;
	int hashLength;
	char *directory, *filename;

	if (argc == 1) {
		puts("velveth - simple hashing program");
		puts("Usage:");
		puts("./velveth directory hash_length {[-file_format][-read_type] filename}");
		puts("\t- directory: directory name for output files");
		puts("\t- hash_length: odd integer (if even, it will be decremented) <= 31 (if above, will be reduced)");
		puts("\t- file_format options: fasta | fastq | eland");
		puts("\t- read_type options: short | shortPaired | short2 | shortPaired2 | long");
		puts("Outputs:");
		puts("\t- directory/Roadmaps");
		puts("\t- directory/Sequences");
		puts("(Both files are picked up by graph, so please leave them there)");
		return 0;
	}

	directory = argv[1];
	filename = malloc((strlen(directory) + 100) * sizeof(char));

	sscanf(argv[2], "%i", &hashLength);

	if (hashLength > 31) {
		printf
		    ("Velvet can't handle k-mers as long as %i! We'll stick to 31 if you don't mind.",
		     hashLength);
		hashLength = 31;
	} else if (hashLength % 2 == 0) {
		printf
		    ("Velvet can't work with even length k-mers, such as %i. We'll use %i instead, if you don't mind.",
		     hashLength, hashLength - 1);
		hashLength--;
	}

	allSequences = parseDataAndReadFiles(argc - 2, &(argv[2]));

	mkdir(directory, 0777);

	strcpy(filename, directory);
	strcat(filename, "/Sequences");
	exportReadSet(filename, allSequences);

	splayTable = newSplayTable(hashLength);

	strcpy(filename, directory);
	strcat(filename, "/Roadmaps");
	inputSequenceArrayIntoSplayTableAndArchive(allSequences,
						   splayTable, filename);

	return 1;
}
