/*
Copyright 2007 Daniel Zerbino (zerbino@ebi.ac.uk)

    This file is part of Velvet.

    Velvet is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Velvet is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Velvet; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#ifndef _ROADMAP_H_
#define _ROADMAP_H_

#include <stdio.h>

struct roadMapArray_st {
	IDnum length;
	RoadMap **array;
	int WORDLENGTH;
};

////////////////////////////////////////////////////////////////////
//      Annotation stuff
////////////////////////////////////////////////////////////////////
Annotation *newAnnotation(IDnum sequenceID, Coordinate position,
			  Coordinate insertedPosition);

void addAnnotation(Annotation * newAnnotation, RoadMap * rdmap);

void incrementAnnotation(Annotation * annot);

IDnum getAnnotSequenceID(Annotation * annot);
Coordinate getFinish(Annotation * annot);
void setFinish(Annotation * annot, Coordinate finish);
Coordinate getStart(Annotation * annot);
Coordinate getPosition(Annotation * annot);
Coordinate getAnnotationLength(Annotation * annot);

Annotation *getNextAnnotation(Annotation * annot);
void setNextAnnotation(Annotation * previous, Annotation * next);

InsertionMarker *getStartMarker(Annotation * annot);
void setStartMarker(Annotation * annot, InsertionMarker * marker);

InsertionMarker *getFinishMarker(Annotation * annot);
void setFinishMarker(Annotation * annot, InsertionMarker * marker);

char *readAnnotation(Annotation * annot);

////////////////////////////////////////////////////////////////////
//      RoadMap stuff
////////////////////////////////////////////////////////////////////
RoadMap *newRoadMap(TightString * tString);
RoadMap *newRoadMapFromLength(Coordinate length);

Annotation *getAnnotation(RoadMap * rdmap);
void setAnnotation(RoadMap * rdmap, Annotation * annot);

Coordinate getMapLength(RoadMap * rdmap);

void destroyRoadMap(RoadMap * rdmap);

char *readRoadMap(RoadMap * rdmap);

void trimRoadMap(RoadMap * rdmap, Coordinate length);

void destroyAllRoadMaps();

void setRoadMapCategory(RoadMap * rdmap, Category category);
Category getRoadMapCategory(RoadMap * rdmap);

// Exports array of RoadMaps using internal format
void exportRoadMapArray(char *filename, RoadMapArray * array);

FILE *openRoadMapFile(char *filename, IDnum sequenceCount, int WORDLENGTH);

void exportRoadMap(FILE * outfile, RoadMap * rdmap);

// Same thing but for the RoadMap file generated by the hash 
RoadMapArray *importRoadMapArray(char *filename);

// Misc
void categorizeRoadMapArray(RoadMapArray * rdmapArray, Category cat);
#endif
