/*
Copyright 2007 Daniel Zerbino (zerbino@ebi.ac.uk)

    This file is part of Velvet.

    Velvet is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Velvet is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Velvet; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#ifndef NULL
#define NULL 0
#endif

#ifndef true
#define true 1
#define false 0
#endif

#define CATEGORIES 2

// Namespace sizes
typedef signed char boolean;
typedef char Nucleotide;
typedef long IDnum;
typedef long Coordinate;
typedef double Time;
typedef unsigned long long Kmer;
typedef unsigned char Quality;
typedef double Probability;
typedef signed char Category;

// Just a sequence string, but with just two bits per character
typedef struct tString_st TightString;

// A simple container when reading files
typedef struct readSet_st ReadSet;

// Hash table structures
typedef struct splayTable_st SplayTable;

// Graph construction structures
typedef struct annotation_st Annotation;
typedef struct roadmap_st RoadMap;
typedef struct roadMapArray_st RoadMapArray;
typedef struct insertionMarker_st InsertionMarker;

// Graph elements
typedef struct arc_st Arc;
typedef struct node_st Node;
typedef struct graph_st Graph;
typedef struct passage_st PassageMarker;
typedef struct passageList_st PassageMarkerList;
typedef struct readStart_st ReadStart;

// Fibonacci heaps used mainly in Tour Bus
typedef struct fibheap FibHeap;
typedef struct fibheap_el FibHeapNode;
typedef struct dfibheap DFibHeap;
typedef struct dfibheap_el DFibHeapNode;

#endif
