/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef RUNTIME
#define RUNTIME

#include "system/Types.h"

typedef void ArachneSignalHandler(int);

void arachne_signal_handler( int signal_number, Bool no_ctrlc = False );
void arachne_signal_handler_standard( int signal_number );
void arachne_signal_handler_no_ctrlc_traceback( int signal_number );
void ArachneInterruptHandler(ArachneSignalHandler* func);

void NoDump( ); // Turn off core dumps.

void RunTime( int no_dump=1,
              ArachneSignalHandler* pSigFunc = &arachne_signal_handler_standard, 
              bool strict = true );

// RunTimeLax is ONLY for use in situations where low stack size cannot cause
// problems in the main program itself.

inline void RunTimeLax( )
{    RunTime( 1, &arachne_signal_handler_standard, false );    }

inline void RunTimeNoTraceback( )
{    RunTime( 1, &arachne_signal_handler_no_ctrlc_traceback );    }

#endif
