#ifndef BIG_FILE_DEFINES_H
#define BIG_FILE_DEFINES_H
// Copyright (c) 2005 Broad Institute/Massachusetts Institute of Technology

/** Make sure we can handle 64-bit addresses in 32-bit architectures.

\file BigFileDefines.h

The following lines partially accommodate the Linux Intel 32-bit architecture 
by changing file addresses from 32 bits to 64 bits.  This also requires the 
use of "stat64" in place of "stat" (both as a class and a function), as 
reflected inthe definition here of "STAT_NAME".

These need to be in place before we include <sys/types.h>, and many
other headers include this one.  Therefore this file is included by
the makefile.  The Makefile_g++ states SYS_DEFS += -imacros
BigFileDefines.h which causes the macro definitions (only) of this
file to be included as part of every compilation done with the
makefile, before any other includes are handled.  Other (unsupported)
compilers do not have this feature and do not get this include.

*/

#ifdef __linux
     #ifndef _LARGEFILE64_SOURCE
     #define _LARGEFILE64_SOURCE
     #endif
     #define _FILE_OFFSET_BITS 64
     #define STAT_NAME stat64
#else
     #define STAT_NAME stat
#endif

#endif //BIG_FILE_DEFINES_H
