// Copyright (c) 2004 Broad Institute of MIT and Harvard

#ifndef	ASSERT_STRUCTURES_H
#define ASSERT_STRUCTURES_H

// This is the common part of Assert.h and Assert.cc
// and declares the classes needed in both.

class assert_structure
{
public:
  const char* expr_string;
  const char* function_name;
  int line;
  const char* filename;

  assert_structure( const char* expr_string_arg,
		    const char* function_name_arg,
		    int line_arg, 
		    const char* filename_arg )
    : expr_string(expr_string_arg),
      function_name(function_name_arg), 
      line(line_arg),
      filename(filename_arg)
  { }
};


class assert_structure2
{
public:
  const char* expr1_string;
  const char* expr2_string;
  const char* function_name;
  int line;
  const char* filename;

  assert_structure2( const char* expr1_string_arg,
		     const char* expr2_string_arg,
		     const char* function_name_arg, 
		     int line_arg,
		     const char* filename_arg )
    : expr1_string(expr1_string_arg), 
      expr2_string(expr2_string_arg),
      function_name(function_name_arg),
      line(line_arg), 
      filename(filename_arg)
  { }
};


#endif
