// Copyright (c) 2004 The Broad Institute/Massachusetts Institute of Technology

#ifndef RANDOMX_H
#define RANDOMX_H

#include "system/Types.h"

extern "C" long randomx( );
extern "C" long srandomx( int x );

// Although randomx returns a long, its actual range is that of a
// 31-bit int.  Therefore constructs like "randomx( ) % billion" are
// quite biased.  For this purpose, big_random is much better, as it
// produces a 62-bit random number:

inline longlong big_random( )
{    return ( longlong( randomx( ) ) << 31 ) ^ longlong( randomx( ) );    }

#endif
