// Copyright (c) 2005 Broad Institute/Massachusetts Institute of Technology

/** SingleReadSensSpec.  Process coverage_map file as output by
    MapNQSCoverage.  Count #bases raw, accepted, and accepted != ref,
    and output one-line summary to stdout.

\file SingleReadSensSpec.cc 

*/

#ifndef FORCE_DEBUG
#define NDEBUG
#endif

#include "MainTools.h"
#include "TokenizeString.h" 
#include "SeqInterval.h"
#include "CoverageAnalyzer.h"
#include "Basevector.h"
#include "math/Functions.h"
#include "polymorphism/BaseMapInfo.h"
#include "polymorphism/CoverageMapIterator.h"


int main( int argc, char *argv[] )
{
  RunTime();

  BeginCommandArguments;
  /// Filename arguments
  CommandArgument_String(IN); // input coverage file
  EndCommandArguments;

  // Read the base counts for each line and call accordingly
  ulonglong raw=0, accept=0, wrong=0;
  for (CoverageMapIterator in(IN); !done(in); ++in) {
    for (ContigCoverageIterator it = contigIt(in); !done(it); ++it) {
      raw += it->allRaw;
      accept += it->allAcc;
      wrong += it->snipAcc();
    }
  }
  double rate = double(wrong)/double(accept);
  pair<double,double> rateint = BinomialConfidenceInterval(wrong, accept);
  double minrate = rateint.first, maxrate = rateint.second;
  cout << IN << "\t" << PERCENT_RATIO(3, accept, raw)
       "\t" << (1.0e6 * minrate) << "\t" << (1.0e6 * rate) << "\t" << (1.0e6 * maxrate)
       << "\t" << -10.0 * log10(maxrate) << "\t" << -10.0 * log10(rate)
       << "\t" << -10.0 * log10(minrate)
       << "\t" << raw << "\t" << accept << "\t" << wrong << "\n";
  return 0;
}


