/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#include "lookup/Hit.h"
#include "FeudalTemplate.h"
#include "system/SystemTemplate.h"

void BasesToQueries(const basevector &bases, vec<Query> &queries, unsigned int K)
{
  KmerIndexSeq next(K);
  queries.reserve(queries.size() + max(0, bases.isize() - int(K-1)));
  next.Reset(bases); 
  const unsigned int last = bases.size()-(K-1);
  for (unsigned int i=0; i<last; ++i) {
    queries.push_back(Query(i, next(bases)));
  }
}

void BasesToQueries(const vecbasevector &bases, vec<Query> &queries, unsigned int K)
{
  int v;
  unsigned int q=0;
  for (v=0; v<bases.size(); ++v)
    q += max(0, bases[v].isize() - int(K-1));
  queries.reserve(q);
  KmerIndexSeq next(K);
  unsigned int pos = 0;
  for (v=0; v<bases.size(); ++v) {
    const basevector &b = bases[v];
    if (b.size()>=K) {
      const unsigned int last = b.size()-K+1;
      next.Reset(b); 
      for (unsigned int i=0; i<last; ++i) {
	queries.push_back(Query(pos+i, next(b)));
      }
    }
    pos += b.size();
  }
}


void ClusterHits::operator()(serfvec<ProcessedHit> &hits)
{
  sort(hits.begin(), hits.end(), CompareProcessedHitsByRcContigQueryStart());
  bool rc;
  unsigned int contig; 
  longlong pos;
  serfvec<ProcessedHit>::iterator it, last, out = hits.begin();
  for (it=hits.begin(); it!=hits.end(); it = last, ++out) {
    // Find range of close-enough hits
    rc = it->IsRc();
    contig = it->TargetContig();
    pos = it->QueryStartOnTarget();
    for (last=it+1; last!=hits.end(); ++last) {
      if (last->IsRc() != rc || last->TargetContig() != contig
	  || last->QueryStartOnTarget() > pos + bw)
	break;
      pos = last->QueryStartOnTarget();
    }
    // Now record this cluster.  We're being slightly tricky here
    // because we're overwriting the input but it's safe because out <= it.
    if (it>out) *out = *it;
    out->SetNHits(totalHits(it, last));
    out->SetBandwidth(pos - it->QueryStartOnTarget());
  }
  // When done, shrink list to valid region and sort by quality 
  hits.resize(distance(hits.begin(), out));
  sort(hits.begin(), hits.end(), CompareProcessedHitsByQuality());
}




