// Copyright (c) 2003 Whitehead Institute for Biomedical Research
// 

#ifndef ASSEMBLY_SUPERDATAMANAGER
#define ASSEMBLY_SUPERDATAMANAGER

#include "assembly/Super.h"
#include "assembly/ContigLocation.h"

class ContigLocationManager;
class IdManager;

class SuperDataManager 
{
  public:
    SuperDataManager( ContigLocationManager *pCLM );

    SuperDataManager( ContigLocationManager *pCLM,
                      IdManager *pIM );

    ~SuperDataManager( );


    int GetSize( ) const;


    Super NewSuper( );

    Super GetSuper( const int id );

    int  GetNumContigLocations( const int id ) const;

    void GetContigLocations( const int id, vec<ContigLocation> &vecCLs ) const;
    int  GetLength( const int id ) const;
    longlong GetSumOfContigLengths( const int id ) const;
    
    void Reverse( const int id );

  private:
    IdManager * mpIdMgr;

    ContigLocationManager * mpContigLocationMgr;
};
  
#endif

