// Copyright (c) 2003 Whitehead Institute for Biomedical Research
// 

#include "assembly/SuperDataManager.h"

#include "assembly/IdManager.h"
#include "assembly/ContigLocationManager.h"

SuperDataManager::SuperDataManager( ContigLocationManager *pCLM )
    : mpIdMgr( new IdManager ),
      mpContigLocationMgr( pCLM )
{
    ForceAssert( mpIdMgr );
    ForceAssert( mpContigLocationMgr );
}

SuperDataManager::SuperDataManager( ContigLocationManager *pCLM,
                                    IdManager *pIM )
    : mpIdMgr( pIM ),
      mpContigLocationMgr( pCLM )
{
    ForceAssert( mpIdMgr );
    ForceAssert( mpContigLocationMgr );
}

SuperDataManager::~SuperDataManager( )
{
    delete mpIdMgr;
}


int
SuperDataManager::GetSize( ) const
{
    return mpIdMgr->GetMaxId() + 1;
}

Super
SuperDataManager::NewSuper( ) 
{
    int id = mpIdMgr->GetNewId();

    return Super( this, id );
}

Super
SuperDataManager::GetSuper( const int id )
{
  if ( id >= 0 && id <= mpIdMgr->GetMaxId() )
    return Super( this, id );
  else
    return Super();
}


int
SuperDataManager::GetNumContigLocations( const int id ) const
{
    return mpContigLocationMgr->GetNumContigLocationsInSuper( id );
}

void
SuperDataManager::GetContigLocations( const int id, vec<ContigLocation> &vecCLs ) const
{
    mpContigLocationMgr->GetBySuper( id, vecCLs );
}


int 
SuperDataManager::GetLength( const int id ) const
{
    return mpContigLocationMgr->GetSuperLength( id );
}

longlong
SuperDataManager::GetSumOfContigLengths( const int id ) const
{
    return mpContigLocationMgr->GetSumOfContigLengths( id );
}

void
SuperDataManager::Reverse( const int id )
{
    ForceAssertGe( id, 0 );
    ForceAssertLe( id, mpIdMgr->GetMaxId() );

    mpContigLocationMgr->Reverse( SuperToken( this, id ) );
}
