// Copyright (c) 2003 Whitehead Institute for Biomedical Research
// 

#ifndef FORCE_DEBUG
#define NDEBUG
#endif

#include "system/Assert.h"

#include "assembly/ReadPair.h"
#include "assembly/ReadPairManager.h"
#include "assembly/Read.h"

pair<ReadToken,ReadToken> 
ReadPair::GetReads() const
{
  return make_pair( GetMgrPtr()->GetRead1( mToken.GetId() ),
                    GetMgrPtr()->GetRead2( mToken.GetId() ) );
}

int
ReadPair::GetExpectedInsertSize() const
{
    Read read1( this->GetRead1() );
    Read read2( this->GetRead2() );

    return ( read1.GetLeftTrim() + read1.GetLength() +
             this->GetExpectedSep() +
             read2.GetLength() + read2.GetLeftTrim() );
}

