// Copyright (c) 2003 Whitehead Institute for Biomedical Research
// 

#include "assembly/ReadLocationInSuper.h"

#include "assembly/Contig.h"
#include "assembly/Super.h"

ContigLocation
ReadLocationInSuper::GetImpliedContigLocation( const ReadLocation &theReadLoc ) const
{
  Contig theContig( theReadLoc.GetContig() );
  
  int contigBegin;
  Orientation contigOrient;
  
  if ( theReadLoc.GetOrientation() == m_orientation )
  {
    contigBegin = this->Begin() - theReadLoc.Begin();
    contigOrient = orient_FW;
  }
  else
  {
    contigBegin = this->Begin() - ( theContig.GetLength() - theReadLoc.End() );
    contigOrient = orient_RC;
  }
  
  int contigEnd = contigBegin + theContig.GetLength();
  
  return ContigLocation( this->GetSuper(), theContig, 
                         Interval( contigBegin, contigEnd ), contigOrient );
}

ReadLocationInSuper
ReadLocationInSuper::GetReversed() const
{
  Super theSuper( this->GetSuper() );
  
  return ReadLocationInSuper( theSuper, this->GetRead(),
                              Interval( theSuper.GetLength() - m_interval.End(),
                                        theSuper.GetLength() - m_interval.Begin() ),
                              Flip( m_orientation ) );
}
