// Copyright (c) 2000, 2001 Whitehead Institute for Biomedical Research
// 

#ifndef DATA_ORIENTATION
#define DATA_ORIENTATION

#include <iostream>

using std::ostream;

enum Orientation {
  orient_FW,
  orient_RC
};

inline
Orientation Flip( const Orientation anOrientation )
{ return ( anOrientation == orient_FW ? orient_RC : orient_FW ); }

inline
Orientation operator+ ( const Orientation lhs, const Orientation rhs )
{
  if ( lhs == rhs ) 
    return orient_FW;
  else
    return orient_RC;
}

inline 
ostream & operator<< ( ostream & out, const Orientation anOrientation )
{
    return out << ( anOrientation == orient_FW ? "+" : "-" );
}
    
#endif
