// Copyright (c) 2003 Whitehead Institute for Biomedical Research
// 

#ifndef ASSEMBLY_IDMANAGER
#define ASSEMBLY_IDMANAGER

class IdManager
{
  public:
    IdManager( );

    int GetMaxId( ) const;

    int GetNewId( );

    void UseId( const int id );

  private:
    int mMaxId;
};

inline
IdManager::IdManager( )
    : mMaxId( -1 )
{
}

inline
int
IdManager::GetMaxId( ) const
{
    return mMaxId;
}

inline
int
IdManager::GetNewId( )
{
    return ++mMaxId;
}

inline
void
IdManager::UseId( const int id )
{
    mMaxId = std::max( mMaxId, id );
}

#endif
