// Copyright (c) 2004 The Broad Institute at MIT and Harvard
// 

#include "assembly/ContigLocation.h"

#include "assembly/Contig.h"

ContigLocation::ContigLocation( const SuperToken &theSuper, const ContigToken &theContig, 
                                const int begin, 
                                const Orientation theOrientation )
  : Location<SuperToken,ContigToken>( theSuper, theContig, 
                                      Interval( begin, begin + Contig(theContig).GetLength() ),
                                      theOrientation )
{}

#include "assembly/Super.h"

ContigLocation
ContigLocation::GetReversed() const
{
  Super theSuper( this->GetSuper() );
  
  return ContigLocation( theSuper, this->GetContig(),
                         Interval( theSuper.GetLength() - m_interval.End(),
                                   theSuper.GetLength() - m_interval.Begin() ),
                         Flip( m_orientation ) );
}

