// Copyright (c) 2003 Whitehead Institute for Biomedical Research
// 


#ifndef FORCE_DEBUG
#define NDEBUG
#endif

#include "assembly/BinaryVecDataManager.h"

template <class T>
void
BinaryVecDataManager<T>::LoadAllData()
{
    if ( ! mbDataLoaded )
    {
        BREADX2( mStrVecFile, mVecData );
        mbDataLoaded = true;
    }
}

template <class T>
void
BinaryVecDataManager<T>::ResizeToFit( const int id )
{
    unsigned int targetSize = id + 1;
    
    if ( mVecData.size() < targetSize )
    {
        unsigned int targetCapacity = mVecData.capacity();
        
        while ( targetCapacity < targetSize )
        {
            targetCapacity = (targetCapacity+1) * 2;
        }
        
        mVecData.reserve( targetCapacity );
        mVecData.resize( targetSize );
    }
}

template <class T>
void
BinaryVecDataManager<T>::Write( const bool bOverwrite,
                                const String &strOutFile )
{
    if ( ! mbModified && 
         IsRegularFile(strOutFile) && 
         IsRegularFile(mStrVecFile) &&
         RealPath(strOutFile) == RealPath(mStrVecFile) )
        return;

    ForceAssert( bOverwrite || ! mbModified || ! IsRegularFile( strOutFile ) );

    this->LoadAllData();

    BinaryWrite2( strOutFile, mVecData );
}

template class BinaryVecDataManager<int>;
template class BinaryVecDataManager<Bool>;


