// Copyright (c) 2000, 2001 Whitehead Institute for Biomedical Research
//

#ifndef FORCE_DEBUG
     #define NDEBUG
#endif
#define STRING_FAST_EXECUTE

#include "String.h"
#include "TokenizeString.h"
#include "Vec.h"

/*
 * Tokenize (with standard separators).
 */
int Tokenize( const String &a_string,
	      vec<String> &tokens )
{
  static vec<char> separators;
  separators.clear( );
  separators.push_back( ' ' );
  separators.push_back( '\t' );
  
  return Tokenize( a_string, separators, tokens );
}



/*
 * Tokenize (with user defined separators).
 */
int Tokenize( const String &a_string,
	      const vec<char> &separators,
	      vec<String> &tokens )
{
  tokens.clear( );
  
  // Parse string.
  static vec< pair<int, int> > token_interval;
  token_interval.clear( );
  bool in_token = false;
  int token_start = 0;
  for (int ii=0; ii<(int)a_string.size( ); ii++) {
    bool matches_separator = false;
    for (int jj=0; jj<(int)separators.size( ); jj++)
      if ( separators[jj] ==a_string[ii] ) {
	matches_separator = true;
	break;
      }

    if ( matches_separator ) {
      if ( in_token ) {
	token_interval.push_back( pair<int, int>( token_start, ii ) );
	in_token = false;
      }
    }
    else {
      if ( !in_token ) {
	token_start = ii;
	in_token = true;
      }
    }
  }
  if ( in_token )
    token_interval.push_back( pair<int, int>( token_start, (int)a_string.size() ) );

  // Create tokens.
  tokens.reserve( token_interval.size( ) );
  for (int ii=0; ii<(int)token_interval.size( ); ii++) {
    int token_length = token_interval[ii].second - token_interval[ii].first;
    tokens.push_back( a_string.substr( token_interval[ii].first, token_length ) );
  }

  // Return number of tokens.
  return (int)token_interval.size( );
}



/*
 * Tokenize (with user defined separators).
 */
int TokenizeStrictly( const String &a_string,
		      const vec<char> &separators,
		      vec<String> &tokens )
{
  tokens.clear( );
  
  // Parse string.
  static vec< pair<int, int> > token_interval;
  token_interval.clear( );
  int token_start = 0;
  for (int ii=0; ii<(int)a_string.size( ); ii++) {
    bool matches_separator = false;
    for (int jj=0; jj<(int)separators.size( ); jj++)
      if ( separators[jj] == a_string[ii] ) {
	matches_separator = true;
	break;
      }

    if ( matches_separator ) {
      token_interval.push_back( pair<int, int>( token_start, ii ) );
      token_start = ii+1;
    }
  }
  token_interval.push_back( pair<int, int>( token_start, (int)a_string.size() ) );

  // Create tokens.
  tokens.reserve( token_interval.size( ) );
  for (int ii=0; ii<(int)token_interval.size( ); ii++) {
    int token_length = token_interval[ii].second - token_interval[ii].first;
    tokens.push_back( a_string.substr( token_interval[ii].first, token_length ) );
  }

  // Return number of tokens.
  return (int)token_interval.size( );
}
