// Copyright (c) 2000-2003 Whitehead Institute for Biomedical Research

// Set.h defines some utilities often used with sets, e.g. Member()
// and i/o operators.

#ifndef SET_H
#define SET_H

#include <iostream>
#include <set>

template<class T> bool Member( const set<T>& the_set, const T& value )
{    return the_set.find(value) != the_set.end( );    }  // Breaks cxx 

template<class T> ostream& operator<<(ostream& out, const set<T>& the_set)
{    out << the_set.size( ) << "\n";
     typename set<T>::const_iterator the_set_iter = the_set.begin(); 
     for ( ; the_set_iter != the_set.end(); ++the_set_iter )
          out << *the_set_iter;
     return out;    }

template<class T> istream& operator>>(istream& in, set<T>& s)
{    int n;
     in >> n;
     char c;
     in.get(c);
 
     T temp;
     for ( int idx = 0; idx < n; ++idx )
     {
       in >> temp;
       s.insert( temp );
     }
     return in;    }

#endif
