// Copyright (c) 2000-2003 Whitehead Institute for Biomedical Research

#ifndef FORCE_DEBUG
     #define NDEBUG
#endif

#include "CoreTools.h"
#include "FastIfstream.h"
#include "Qualvector.h"

/// \file
/// \ingroup grp_quals
/// \copydoc Qualvector.h

void Print( ostream &out, const qualvector &q, const String &name, 
            const int scores_per_line )
{
    out << ">" << name << "\n";
    for ( int j = 0; j < q.size( ); ++j )
    {    
        if ( j % scores_per_line == 0 && j > 0 ) 
            out << "\n";
        else if ( j > 0 ) 
            out << " ";
        out << (int) q[j];
    }
    out << "\n"; 
}

void ReadFastaQuals( const String& fn, vecqualvector& qual,
     const vec<int>* ids_to_read )
{    int total_seqs = 0;
     longlong total_bases = 0;
     int count = 0;
     for ( int pass = 1; pass <= 2; pass++ )
     {    if ( pass == 2 ) qual.Reserve( total_bases, total_seqs );
          fast_ifstream quals(fn);
          String line;
          qualvector q;
          Bool first = True;
          while(1)
          {    getline( quals, line );
               if ( quals.fail( ) )
               {    if ( pass == 1 ) 
                    {    total_bases += q.size( );
                         ++total_seqs;    }
                    if ( pass == 2 ) qual.push_back(q);
                    q.clear( );
                    break;    }
               ForceAssert( line.size( ) > 0 );
               if ( line[0] == '>' )
               {    if ( !first )
                    {    if ( pass == 1 ) 
                         {    total_bases += q.size( );
                              ++total_seqs;    }
                         if ( pass == 2 ) qual.push_back(q);    }
                    first = False;
                    q.clear( );
                    while(1)
                    {    char c;
                         quals.peek(c);
                         if ( quals.fail( ) || c == '>' ) break;
                         getline( quals, line );
                         for ( int j = 0; j < (int) line.size( ); j++ )
                              ForceAssert( isspace(line[j]) || isdigit(line[j]) );
                         istrstream i( line.c_str( ) );
                         while(1)
                         {    int n;
                              i >> n;
                              if ( i.fail( ) ) break;
                              q.push_back(n);    }    }    }
               if ( quals.fail( ) )
               {    if ( pass == 1 ) 
                    {    total_bases += q.size( );
                         ++total_seqs;    }
                    if ( pass == 2 ) 
                    {    if ( ids_to_read == 0 || BinMember( *ids_to_read, count ) )
                              qual.push_back(q);
                         ++count;    }
                    q.clear( );
                    break;    }    }    }    }
