/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef PAIR_H
#define PAIR_H

/**

\file Pair.h

Functions to help with managing std::pair class

*/


#include <utility>
#include <iostream>

// This is a hack to get ostream iterators to work on pairs.  Without
// this hack (which is illegal and technically results in undefined
// behavior and may break in future releases), namespace-resolution
// wackiness results in std::ostream_iterator on std::pair<int,int>
// only looking in namespace std for the operator<< on pair<int,int>.
// Therefore, we inject the following definition into namespace std,
// which kind of defeats the purpose of having a "standard" namespace,
// since we've just changed that standard.
//
// For more details, see http://tinyurl.com/dtxrx

namespace std {

template<class First, class Second>
ostream & operator<<(ostream & os, const pair<First, Second> & p) {
  os << p.first << " " << p.second;
  return os;
}

}

// This is an alternative hack to get copy() to work on vecs of pairs,
// which is here in case the above injection breaks at some point.
//
// Instead of calling
//   copy( v.begin(), v.end(), ostream_iterator< pair<int,int> >( cout, " " ) );
// call instead
//   copy( v.begin(), v.end(), ostream_iterator< printable_pair<int,int> >( cout, " " ) );

template < typename First, typename Second >
class printable_pair {
 public:
  First first;
  Second second;

  printable_pair( const std::pair<First,Second>& p ) 
    : first( p.first ), second( p.second ) 
  {}
};

using std::ostream;

template<class First, class Second>
ostream & operator<<(ostream & os, const printable_pair<First, Second> & p) {
  os << p.first << " " << p.second;
  return os;
}

#endif //PAIR_H
