// Copyright (c) 2000-2003 Whitehead Institute for Biomedical Research

// Class read_part is designed to read parts of a file.  This read is quite
// efficient, provided that the parts of the file are in order.

#include "CoreTools.h"
#include "FeudalReadPart.h"

#include <string.h>
#include <sys/types.h>

void read_part::Fetch( longlong start, longlong nbytes, char* to )
{
  longlong remainder;
  longlong target_pagestart, available;

  while ( nbytes > 0 )
  {
    remainder = start % pagesize_;
    target_pagestart = start - remainder;
    if ( pagestart_ != target_pagestart )
    {
      pagestart_ = target_pagestart;
      lseek( fd_, pagestart_, SEEK_SET );
      read( fd_, where_, pagesize_ );    
    }
    available = min( nbytes, pagestart_ + pagesize_ - start );
    
    memcpy( to, where_ + remainder, available );
    to += available;
    start += available;
    nbytes -= available;
  }
}

