/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2007) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef FORCE_DEBUG
     #define NDEBUG
#endif

#include "Basevector.h"
#include "Bitvector.h"
#include "CoreTools.h"
#include "Feudal.h"
#include "FeudalMimic.h"

void Mimic( const vecbasevector& in, vecbitvector& out )
{    longlong nbases = 0;
     int nseqs = in.size( );
     for ( int i = 0; i < in.size( ); i++ )
          nbases += in[i].size( );
     out.clear( );
     out.Reserve( nbases/32 + nseqs, nseqs );
     for ( int i = 0; i < in.size( ); i++ )
     {    static bitvector b;
          b.Setsize( in[i].size( ) );
          b.Zero( );
          out.push_back(b);    }    }

void Mimic( const vecbasevector& in, vecvec<unsigned char>& out, const unsigned char value )
{    longlong nbases = 0;
     int nseqs = in.size( );
     for ( int i = 0; i < in.size( ); i++ )
          nbases += in[i].size( );
     out.clear( );
     out.Reserve( nbases, nseqs );
     for ( int i = 0; i < in.size( ); i++ )
     {    static serfvec<unsigned char> q;
          q.resize( in[i].size( ) );
          for ( int j = 0; j < q.size( ); j++ )
               q[j] = value;
          out.push_back(q);    }    }

void Mimic( const vecbasevector& in, vecvec<unsigned short>& out )
{    longlong nbases = 0;
     int nseqs = in.size( );
     for ( int i = 0; i < in.size( ); i++ )
          nbases += in[i].size( );
     out.clear( );
     out.Reserve( nbases, nseqs );
     for ( int i = 0; i < in.size( ); i++ )
     {    static serfvec<unsigned short> q;
          q.resize( in[i].size( ) );
          for ( int j = 0; j < q.size( ); j++ )
               q[j] = 0;
          out.push_back(q);    }    }

void Mimic( const vecbasevector& in, vecvec<int>& out )
{    longlong nbases = 0;
     int nseqs = in.size( );
     for ( int i = 0; i < in.size( ); i++ )
          nbases += in[i].size( );
     out.clear( );
     out.Reserve( nbases, nseqs );
     for ( int i = 0; i < in.size( ); i++ )
     {    static serfvec<int> q;
          q.resize( in[i].size( ) );
          for ( int j = 0; j < q.size( ); j++ )
               q[j] = 0;
          out.push_back(q);    }    }

void Mimic( const vecbasevector& in, vecvec<float>& out )
{    longlong nbases = 0;
     int nseqs = in.size( );
     for ( int i = 0; i < in.size( ); i++ )
          nbases += in[i].size( );
     out.clear( );
     out.Reserve( nbases, nseqs );
     for ( int i = 0; i < in.size( ); i++ )
     {    static serfvec<float> q;
          q.resize( in[i].size( ) );
          for ( int j = 0; j < q.size( ); j++ )
               q[j] = 0.0;
          out.push_back(q);    }    }
