/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2007) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef FETCHREADS
#define FETCHREADS

#include "Basevector.h"
#include "CoreTools.h"
#include "Qualvector.h"

/// \file FetchReads.h
/// Routines for getting reads from a fasta file into mastervecs.
/// (vecbasevector and vecString). 
/// Can also use FastFetchReads in FastaFileset.h, which is twice as fast.

/// ambiguous_base: I recognize "." and "-", which appear in a file of methylated
/// Neurospora sequence from Eric Selker.  I'm not sure what they mean.
/// Ambiguous bases are saved as random bases.

inline int ambiguous_base(char c)
{    if ( c == 'a' || c == 'A' ) return 0;
     if ( c == 'c' || c == 'C' ) return 0;
     if ( c == 'g' || c == 'G' ) return 0;
     if ( c == 't' || c == 'T' ) return 0;
     if ( isalpha(c) ) return 1;
     if ( c == '.' ) return 1;
     if ( c == '-' ) return 1;
     if ( c == '*' ) return 1;
     return 0;    }

/// Put reads from a fasta file into a vecbasevector and a names vector.
/// Ambiguous bases are saved as random bases.
/// If the names vector pointer is empty, ignores names and thus preserves
/// efficiency.
///
/// The vector b is cleared first.

void FetchReads( vecbasevector& b, vecqualvector& q, vecString * names,
                 unsigned int n, String fasta_file, 
                 int amb_break = 0, int min_size = 0, 
                 ostream& out = cout,
                 Bool no_q = False, const vec<int>* ids_to_read = 0 );

inline void FetchReads( vecbasevector& b, vecString& names, String fasta_file )
{    vecqualvector q;
     FetchReads( b, q, &names, 0, fasta_file, 0, 0, cout, True );    }

///Put reads from a fasta file into a vecbasevector.
/// Ambiguous bases are saved as random bases.
void FetchReads( vecbasevector& b, vecqualvector& q, unsigned int n, 
                 String fasta_file, int amb_break = 0, int min_size = 0, 
                 ostream& out = cout,
                 Bool no_q = False, const vec<int>* ids_to_read = 0 );

///Put reads from a fasta file into a vecbasevector.
/// Ambiguous bases are saved as random bases.
void FetchReads( vecbasevector& b, unsigned int n, String fasta_file, 
     int amb_break = 0, int min_size = 0, ostream& out = cout,
     const vec<int>* ids_to_read = 0 );

/// Read a "fasta" file whose entries are floats.

void FetchReads( vecvec<float>& f, const String& fasta_file );

#endif
