// Copyright (c) 2000-2003 Whitehead Institute for Biomedical Research
// 


#ifndef FASTANAMEPARSER_H
#define FASTANAMEPARSER_H

#include "String.h"

class FastaNameParser {
 public:
  virtual ~FastaNameParser() {}
  virtual void extractNameFromBuffer( char* buffer, String& name ) const = 0;
};

class FullNameParser : public FastaNameParser {
 public:
  virtual ~FullNameParser() {}
  virtual void extractNameFromBuffer( char* buffer, String& name ) const;
};

class FirstWordParser : public FastaNameParser {
 public:
  virtual ~FirstWordParser() {}
  virtual void extractNameFromBuffer( char* buffer, String& name ) const;
};

class LastWordParser : public FastaNameParser {
 public:
  virtual ~LastWordParser() {}
  virtual void extractNameFromBuffer( char* buffer, String& name ) const;
};

class Riken_cDNA_Parser : public FastaNameParser {
 public:
  virtual ~Riken_cDNA_Parser() {}
  void extractNameFromBuffer( char* buffer, String& name ) const;
};

class TruncatedLastWordParser : public LastWordParser {
 public:
  virtual ~TruncatedLastWordParser() {}
  void extractNameFromBuffer( char* buffer, String& name ) const;
};


#endif

