/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

/** Make a forest of binary files with prefix SFF from a 454 sff file.

\file MakeSffInfo.cc

Also saves sequences in fasta format if a FASTA destination file is given.

*/

#include "MainTools.h"
#include "454/sff/SffTypes.h"
#include "454/sff/SffInfo.h"

int main( int argc, char *argv[])
{ 
  RunTime();

  BeginCommandArguments;
  // The sffinfo file with the data. This should be the header name for a
  // forest of binary sffinfo files that have been processed and aligned by
  // us. It must be a : separated list if MULTIPLE_SFFINFOS is True.
  CommandArgument_String(SFF);
  // If we want text output, give a name for the file.
  CommandArgument_String_OrDefault(FASTA,"");
  EndCommandArguments;

  String OUT_PREFIX=SFF.Before(".sff");//Fail if name does not have .sff

  SffInfo info;
  sff::CommonHeader chead = info.ReadFromSff(SFF);
  cout << "Read SFF file " << SFF << "\n" << chead << "\n";
  info.Write(OUT_PREFIX);
  cout << "Wrote file forest to " << OUT_PREFIX << "\n";
  
  if (!FASTA.empty()) {
    info.WriteFasta(FASTA);
  }

  return 0;
}

