/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef PREDICTOR_PARAMETER_HANDLER_H
#define PREDICTOR_PARAMETER_HANDLER_H



/// Interface for getting/putting additional parameters in a PhredTable.
///
/// \class PredictorParameterHandler

struct PredictorParameterHandler {
  virtual ~PredictorParameterHandler() {}
  virtual String GetPredictorParameters() const = 0;
  virtual void SetPredictorParameters(const String & params) = 0;
};

#endif //PREDICTOR_PARAMETER_HANDLER_H
