// Copyright (c) 2005 Broad Institute of MIT and Harvard
//
// FlowVectorManager.h

// The class FlowVectorManager defines the corresponding manger object
// which can be used to manage a collection of flow vectors of the same
// flow order.  (Thus a new FlowVectorManager object should be
// instantiated to manage  a collection of flow vectors with a different
// flow order.)
// 

#ifndef FLOWDATA_FLOWVECTORMANAGER
#define FLOWDATA_FLOWVECTORMANAGER

#include "454/flowdata/FeudalPlusDataManager.h"

#include "assembly/PrefetchStrategy.h"


//
// FlowVectorManager is conceptually similar to ReadSequenceManager.
// Most of the methods in FlowVectorManager have analogues in ReadSequenceManager,
// although their implementations are slightly different:
// ReadSequenceManager is primarily an interface for (several) FeudalDataManagers,
// whereas FlowVectorManager is primarily an interface for a FeudalPlusDataManager.
//


class FlowVectorManager
{
public:
  FlowVectorManager();

  FlowVectorManager( const String & strFlowVectorsFile );

  ~FlowVectorManager();

  
  const FlowOrder  & GetFlowOrder () const;
  const FlowVector & GetFlowVector( const int id ) const;
  int                GetLength    ( const int id ) const;

  void SetFlowOrder  ( const FlowOrder  & floworder );
  void SetFlowVector ( const int id,
		       const FlowVector & flowvector );

  bool Verify( const int id ) const;

  void Write( const bool bOverwrite,
	      const String & strFlowVectorsFile );

  /// Give manager a new prefetch strategy.  The manager will delete
  /// its old strategy and take responsibility for managing the new one.
  void SetPrefetchStrategy( PrefetchStrategy *pPrefetchStrategy );

  ///Remove all P flows from all structures managed by this.
  void RemovePFlows();

  
private:
  FlowValuesManager * mpFlowValuesMgr;
  PrefetchStrategy  * mpPrefetchStrategy;

  ///Ensure that the data for this idhas been loaded so we can access it.
  void EnsureLoaded(int id) const;
};


#endif

