// Copyright (c) 2005 Broad Institute of MIT and Harvard
//
// FlowReadToken.h

// The type FlowReadToken represents a FlowRead object as a Token
// in the corresponding FlowDataBroker.


#ifndef FLOWDATA_FLOWREADTOKEN
#define FLOWDATA_FLOWREADTOKEN

#include "assembly/Token.h"

class FlowDataBroker;
class FlowRead;

typedef Token< FlowRead,FlowDataBroker > FlowReadToken;

#include <iostream>

using std::ostream;

inline
ostream & operator << ( ostream & out, const FlowReadToken & theFlowReadToken )
{
  return out << 'F' << theFlowReadToken.GetId();
}

#endif
